<?php include "check_login.php"; ?>
<?php 
include "dbcon.php";
$completed = 0;
$inProgress = 0;
$pending = 0;

$project_id = (int)$_GET['project_id'];

$phaseQ = mysqli_query($conn,"
    SELECT status FROM project_phases
    WHERE project_id = $project_id
");

while($row = mysqli_fetch_assoc($phaseQ)){
    if($row['status'] == 'approved'){
        $completed++;
    } elseif($row['status'] == 'in_progress'){
        $inProgress++;
    } else {
        $pending++;
    }
}

$labels = [];
$completedData = [];
$progressData = [];
$pendingData = [];

$phQ = mysqli_query($conn,"
    SELECT phase_name, status
    FROM project_phases
    WHERE project_id = $project_id
    ORDER BY phase_no
");

while($p = mysqli_fetch_assoc($phQ)){

    $labels[] = $p['phase_name'];

    if($p['status'] == 'approved'){
        $completedData[] = 100;
        $progressData[]  = 0;
        $pendingData[]   = 0;
    }
    elseif($p['status'] == 'in_progress'){
        $completedData[] = 0;
        $progressData[]  = 60;   // visual progress
        $pendingData[]   = 40;
    }
    else{
        $completedData[] = 0;
        $progressData[]  = 0;
        $pendingData[]   = 100;
    }
}


?>
<!DOCTYPE html>
<html lang="zxx">
<head>
    <meta charset="utf-8" />
    <meta http-equiv="x-ua-compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="description" content="" />
    <meta name="keyword" content="" />
    <meta name="author" content="WRAPCODERS" />
    <!--! The above 6 meta tags *must* come first in the head; any other head content must come *after* these tags !-->
    <!--! BEGIN: Apps Title-->
    <title>Duralux || Dashboard</title>
    <!--! END:  Apps Title-->
    <!--! BEGIN: Favicon-->
    <link rel="shortcut icon" type="image/x-icon" href="assets/images/favicon.ico" />
    <!--! END: Favicon-->
    <!--! BEGIN: Bootstrap CSS-->
    <link rel="stylesheet" type="text/css" href="assets/css/bootstrap.min.css" />
    <!--! END: Bootstrap CSS-->
    <!--! BEGIN: Vendors CSS-->
    <link rel="stylesheet" type="text/css" href="assets/vendors/css/vendors.min.css" />
    <link rel="stylesheet" type="text/css" href="assets/vendors/css/daterangepicker.min.css" />
    <!--! END: Vendors CSS-->
    <!--! BEGIN: Custom CSS-->
    <link rel="stylesheet" type="text/css" href="assets/css/theme.min.css" />
    <!--! END: Custom CSS-->
 
</head>

<body>
    <!--! ================================================================ !-->
    <!--! [Start] Navigation Manu !-->
    <!--! ================================================================ !-->
<?php include("sidebar.php"); ?>
    <!--! ================================================================ !-->
    <!--! [End]  Navigation Manu !-->
    <!--! ================================================================ !-->
    <!--! ================================================================ !-->
    <!--! [Start] Header !-->
    <!--! ================================================================ !-->
  <?php include("header.php"); ?>
    <!--! ================================================================ !-->
    <!--! [End] Header !-->
    <!--! ================================================================ !-->
    <!--! ================================================================ !-->
    <!--! [Start] Main Content !-->
    <!--! ================================================================ !-->
    <main class="nxl-container">
        <div class="nxl-content">
            <!-- [ page-header ] start -->
            <div class="page-header">
                <div class="page-header-left d-flex align-items-center">
                    <div class="page-header-title">
                        <h5 class="m-b-10">Dashboard</h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
                        <li class="breadcrumb-item">Dashboard</li>
                    </ul>
                </div>
         
            </div>
            <!-- [ page-header ] end -->
            <!-- [ Main Content ] start -->
            <div class="main-content">
                <div class="row">   

                    <div class="col-xxl-3 col-md-6">
                        <div class="card stretch stretch-full">
                            <div class="card-body">
                          
                    
                            <div class="text-center">
                                <h5 class="fw-bold mb-3">Project Progress</h5>
                                <canvas id="phaseDoughnutChart" height="200"></canvas>
                            </div>

                            </div>
                        </div>
                    </div>

                        <div class="col-xxl-9 col-md-6">
                        <div class="card stretch stretch-full">
                            <div class="card-body">
                                <h5 class="fw-bold mb-3">Phase-wise Project Progress</h5>
                                <canvas id="phaseBarChart" height="300"></canvas>
                            </div>
                          </div>
                    </div>



                 </div>
            </div>
            <!-- [ Main Content ] end -->
        </div>
        <!-- [ Footer ] start -->
<?php include("footer.php"); ?>
        <!-- [ Footer ] end -->
    </main>
    <!--! ================================================================ !-->
    <!--! [End] Main Content !-->
    <!--! ================================================================ !-->
    <!--! ================================================================ !-->
    <!--! BEGIN: Theme Customizer !-->
    <!--! ================================================================ !-->
 
    <!--! ================================================================ !-->
    <!--! [End] Theme Customizer !-->
    <!--! ================================================================ !-->
    <!--! ================================================================ !-->
    <!--! Footer Script !-->
    <!--! ================================================================ !-->
    <!--! BEGIN: Vendors JS !-->
    <script src="assets/vendors/js/vendors.min.js"></script>
    <!-- vendors.min.js {always must need to be top} -->
    <script src="assets/vendors/js/daterangepicker.min.js"></script>
    <script src="assets/vendors/js/apexcharts.min.js"></script>
    <script src="assets/vendors/js/circle-progress.min.js"></script>
    <!--! END: Vendors JS !-->
    <!--! BEGIN: Apps Init  !-->
    <script src="assets/js/common-init.min.js"></script>
    <script src="assets/js/dashboard-init.min.js"></script>
    <!--! END: Apps Init !-->
    <!--! BEGIN: Theme Customizer  !-->
    <script src="assets/js/theme-customizer-init.min.js"></script>
    <!--! END: Theme Customizer !-->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
/* ===== Chart 1 : Doughnut ===== */
const ctxDoughnut = document
    .getElementById('phaseDoughnutChart')
    .getContext('2d');

new Chart(ctxDoughnut, {
    type: 'doughnut',
    data: {
        labels: ['Completed','In Progress','Pending'],
        datasets: [{
            data: [
                <?= $completed ?>,
                <?= $inProgress ?>,
                <?= $pending ?>
            ],
            backgroundColor: ['#28a745','#0d6efd','#adb5bd']
        }]
    },
    options: {
        cutout: '65%',
        plugins: {
            legend: { position: 'bottom' }
        }
    }
});
</script>

<script>
/* ===== Chart 2 : Phase-wise Bar ===== */
const ctxBar = document
    .getElementById('phaseBarChart')
    .getContext('2d');

new Chart(ctxBar, {
    type: 'bar',
    data: {
        labels: <?= json_encode($labels) ?>,
        datasets: [
            {
                label: 'Completed',
                data: <?= json_encode($completedData) ?>,
                backgroundColor: '#28a745'
            },
            {
                label: 'In Progress',
                data: <?= json_encode($progressData) ?>,
                backgroundColor: '#0d6efd'
            },
            {
                label: 'Pending',
                data: <?= json_encode($pendingData) ?>,
                backgroundColor: '#dee2e6'
            }
        ]
    },
    options: {
        indexAxis: 'y',
        scales: {
            x: { stacked: true, display: false },
            y: { stacked: true }
        },
        plugins: {
            legend: { position: 'bottom' }
        }
    }
});
</script>


</body>

</html>