<?php
session_start();

if (isset($_SESSION['admin_id'])) {
    header("Location: dashboard.php");
    exit;
}

if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = hash('sha256', uniqid(mt_rand(), true));
}
?>
<!DOCTYPE html>
<html lang="zxx">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    
    <title>Admin</title>
    
    <link rel="shortcut icon" type="image/x-icon" href="assets/images/favicon.ico">
 
    <link rel="stylesheet" type="text/css" href="assets/css/bootstrap.min.css">
  
    <link rel="stylesheet" type="text/css" href="assets/vendors/css/vendors.min.css">
<link rel="stylesheet" type="text/css" href="assets/css/theme.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


</head>

<body>


   <main class="auth-creative-wrapper">
        <div class="auth-creative-inner">
            <div class="creative-card-wrapper">
                <div class="card my-4 overflow-hidden" style="z-index: 1">
                    <div class="row flex-1 g-0">
                        <div class="col-lg-6 h-100 my-auto order-1 order-lg-0">
                            <div class="wd-50 bg-white p-2 rounded-circle shadow-lg position-absolute translate-middle top-50 start-50 d-none d-lg-block">
                                <img src="assets/images/logo-abbr.png" alt="" class="img-fluid">
                            </div>
                            <div class="creative-card-body card-body p-sm-5">
                                <h2 class="fs-20 fw-bolder mb-4">Login</h2>
                                <h4 class="fs-13 fw-bold mb-2">Login to your account</h4>
                                <p class="fs-12 fw-medium text-muted">Thank you for get back <strong>Nelel</strong> web applications, let's access our the best recommendation for you.</p>
                                <form method="POST" action="login_check.php" class="w-100 mt-4 pt-2">
                                    <div class="mb-4">
                                 <input type="text" name="username" class="form-control" placeholder="Username" required>
                                    </div>
                                     <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token']; ?>">
                                    <div class="mb-3">
                                 <input type="password" name="password"  class="form-control" placeholder="Password" required>
                                    </div>
                              
                                    <div class="mt-5">
                                        <button type="submit" class="btn btn-lg btn-primary w-100">Login</button>
                                    </div>
                                </form>
                              
                               
                            </div>
                        </div>
                        <div class="col-lg-6 bg-primary order-0 order-lg-1">
                            <div class="h-100 d-flex align-items-center justify-content-center">
                                <img src="assets/images/auth/auth-user.png" alt="" class="img-fluid">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

   
<?php if (isset($_GET['error'])) { ?>
<script>
Swal.fire({
  icon:'error',
  title:'Login Failed',
  text:'Invalid login credentials',
  timer:2000,
  showConfirmButton:false
});
</script>
<?php } ?>

<?php if (isset($_GET['blocked'])) { ?>
<script>
Swal.fire({
  icon:'warning',
  title:'Account Locked',
  text:'Too many failed attempts. Try again after 15 minutes.'
});
</script>
<?php } ?>

    <script src="assets/vendors/js/vendors.min.js"></script>

    <script src="assets/js/common-init.min.js"></script>


   
</html>