<?php
session_start();

if (isset($_SESSION['admin_id'])) {
    header("Location: dashboard.php");
    exit;
}

if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = hash('sha256', uniqid(mt_rand(), true));
}
?>
<!DOCTYPE html>
<html lang="zxx">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    
    <title>Admin</title>
    
    <link rel="shortcut icon" type="image/x-icon" href="assets/images/favicon.ico">
 
    <link rel="stylesheet" type="text/css" href="assets/css/bootstrap.min.css">
  
    <link rel="stylesheet" type="text/css" href="assets/vendors/css/vendors.min.css">
<link rel="stylesheet" type="text/css" href="assets/css/theme.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


</head>

<body>

    <main class="auth-minimal-wrapper">
        <div class="auth-minimal-inner">
            <div class="minimal-card-wrapper">
                <div class="card mb-4 mt-5 mx-4 mx-sm-0 position-relative">
                    <div class="wd-50 bg-white p-2 rounded-circle shadow-lg position-absolute translate-middle top-0 start-50">
                        <img src="assets/images/logo-abbr.png" alt="" class="img-fluid">
                    </div>
                    <div class="card-body p-sm-5">
                        <h2 class="fs-20 fw-bolder mb-4">Login</h2>
                        <h4 class="fs-13 fw-bold mb-2">Adminstration Login</h4>
                   
                        <form method="POST" action="login_check.php" class="w-100 mt-4 pt-2">
                            <div class="mb-4">
                                <input type="text" name="username" class="form-control" placeholder="Email or Username" required>
                            </div>
                            <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token']; ?>">
                            <div class="mb-3">
                                <input type="password" name="password"  class="form-control" placeholder="Password" required>
                            </div>
                        
                                   
                                </div>
                            </div>
                            <div class="mt-5">
                                <button type="submit" class="btn btn-lg btn-primary w-100">Login</button>
                            </div>
                        </form>
           
                    </div>
                </div>
            </div>
        </div>
    </main>
<?php if (isset($_GET['error'])) { ?>
<script>
Swal.fire({
  icon:'error',
  title:'Login Failed',
  text:'Invalid login credentials',
  timer:2000,
  showConfirmButton:false
});
</script>
<?php } ?>

<?php if (isset($_GET['blocked'])) { ?>
<script>
Swal.fire({
  icon:'warning',
  title:'Account Locked',
  text:'Too many failed attempts. Try again after 15 minutes.'
});
</script>
<?php } ?>

    <script src="assets/vendors/js/vendors.min.js"></script>

    <script src="assets/js/common-init.min.js"></script>


   
</html>