<?php include "check_login.php"; ?>
<?php
include 'dbcon.php';

if (!isset($_GET['project_id'])) {
    die("Invalid Request");
}

$project_id = (int)$_GET['project_id'];


if (isset($_GET['notify_id'])) {
    $notify_id = (int)$_GET['notify_id'];
    mysqli_query($conn, "UPDATE notifications SET is_seen=1 WHERE id=$notify_id");
}


$q = "SELECT * FROM projects WHERE id = $project_id";
$res = mysqli_query($conn, $q);

if (mysqli_num_rows($res) == 0) {
    die("Lead not found");
}

$lead = mysqli_fetch_assoc($res);
$phasesQd = mysqli_query($conn, "
    SELECT 
        id,
        phase_no,
        phase_name,
        status
    FROM project_phases
    WHERE project_id = $project_id
    ORDER BY phase_no ASC
");


?>

<!DOCTYPE html>
<html lang="zxx">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
  
    <title>Leads</title>
  
    <link rel="shortcut icon" type="image/x-icon" href="assets/images/favicon.ico">
  
    <link rel="stylesheet" type="text/css" href="assets/css/bootstrap.min.css">
 
    <link rel="stylesheet" type="text/css" href="assets/vendors/css/vendors.min.css">
    <link rel="stylesheet" type="text/css" href="assets/vendors/css/select2.min.css">
    <link rel="stylesheet" type="text/css" href="assets/vendors/css/select2-theme.min.css">
    <link rel="stylesheet" type="text/css" href="assets/vendors/css/datepicker.min.html">
    
    <link rel="stylesheet" type="text/css" href="assets/css/theme.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

</head>

<body>
<?php include("sidebar.php"); ?>
<?php include("header.php"); ?>   

    <main class="nxl-container">
        <div class="nxl-content">
            <!-- [ page-header ] start -->
            <div class="page-header">
                <div class="page-header-left d-flex align-items-center">
                    <div class="page-header-title">
                        <h5 class="m-b-10">Leads</h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                        <li class="breadcrumb-item">View</li>
                    </ul>
                </div>
                <div class="page-header-right ms-auto">
                    <div class="page-header-right-items">
                        <div class="d-flex d-md-none">
                            <a href="javascript:void(0)" class="page-header-right-close-toggle">
                                <i class="feather-arrow-left me-2"></i>
                                <span>Back</span>
                            </a>
                        </div>
                        <div class="d-flex align-items-center gap-2 page-header-right-items-wrapper">
                            <a onclick="printPage()" class="btn btn-icon btn-light-brand">
                                <i class="feather-printer"></i>
                            </a>
                       
                        </div>
                    </div>
                    <div class="d-md-none d-flex align-items-center">
                        <a href="javascript:void(0)" class="page-header-right-open-toggle">
                            <i class="feather-align-right fs-20"></i>
                        </a>
                    </div>
                </div>
            </div>
            <!-- [ page-header ] end -->
            <div class="bg-white py-3 border-bottom rounded-0 p-md-0 mb-0">
                <div class="d-md-none d-flex">
                    <a href="javascript:void(0)" class="page-content-left-open-toggle">
                        <i class="feather-align-left fs-20"></i>
                    </a>
                </div>
                
                <div class="d-flex align-items-center justify-content-between">
                    <div class="nav-tabs-wrapper page-content-left-sidebar-wrapper">
                        <div class="d-flex d-md-none">
                            <a href="javascript:void(0)" class="page-content-left-close-toggle">
                                <i class="feather-arrow-left me-2"></i>
                                <span>Back</span>
                            </a>
                        </div>
                        <ul class="nav nav-tabs nav-tabs-custom-style" id="myTab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#profileTab">Profile</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" data-bs-toggle="tab" data-bs-target="#proposalTab">Assign</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" data-bs-toggle="tab" data-bs-target="#tasksTab">Project Progress</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" data-bs-toggle="tab" data-bs-target="#notesTab">Notes</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" data-bs-toggle="tab" data-bs-target="#commentTab">Comments</button>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <!-- [ Main Content ] start -->
            <div class="main-content">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="profileTab" role="tabpanel">
                        <div class="card card-body lead-info">
                            <div class="mb-4 d-flex align-items-center justify-content-between">
                                <h5 class="fw-bold mb-0">
                                    <span class="d-block mb-2">Lead Information :</span>
                                    <span class="fs-12 fw-normal text-muted d-block">Following information for your lead</span>
                                </h5>
                               
                            </div>
                            <div class="row mb-4">
                                <div class="col-lg-2 fw-medium">Name</div>
                                <div class="col-lg-10"><a href="javascript:void(0);"><?php echo $lead['name']; ?></a></div>
                            </div>
                          
                            <div class="row mb-4">
                                <div class="col-lg-2 fw-medium">Company</div>
                                <div class="col-lg-10"><a href="javascript:void(0);"><?php echo $lead['company_name']; ?></a></div>
                            </div>
                            <div class="row mb-4">
                                <div class="col-lg-2 fw-medium">Email</div>
                                <div class="col-lg-10"><a href="javascript:void(0);"><?php echo $lead['email']; ?></a></div>
                            </div>
                            <div class="row mb-4">
                                <div class="col-lg-2 fw-medium">Phone</div>
                                <div class="col-lg-10"><a href="javascript:void(0);"><?php echo $lead['mobile']; ?></a></div>
                            </div>
                        
                            <div class="row mb-4">
                                <div class="col-lg-2 fw-medium">Address</div>
                                <div class="col-lg-10"><a href="javascript:void(0);"><?php echo $lead['address']; ?></a></div>
                            </div>
                            <div class="row mb-4">
                                <div class="col-lg-2 fw-medium">Project Location</div>
                                <div class="col-lg-10"><a href="javascript:void(0);"><?php echo $lead['project_location']; ?></a></div>
                            </div>
                            <div class="row mb-4">
                                <div class="col-lg-2 fw-medium">Any Initial Notes</div>
                                <div class="col-lg-10"><a href="javascript:void(0);"><?php echo $lead['initial_notes']; ?></a></div>
                            </div>
                           <div class="row mb-4">
                                <div class="col-lg-2 fw-medium">Lead Status</div>
                                <div class="col-lg-10"><a href="javascript:void(0);">
                                 
                                <?php 
                                if($lead['status'] == "pending"){
?>
<a href="javascript:void(0);" class="badge bg-soft-warning text-warning">Pending</a>
<?php
                                }
                                elseif($lead['status'] == "In Progress"){
?>
<a href="javascript:void(0);" class="badge bg-soft-primary text-primary">In Progress</a>

<?php

                                }
                                 elseif($lead['status'] == "complete"){
?>
<a href="javascript:void(0);" class="badge bg-soft-success text-success">Complete</a>
                                    <?php
                                 }
                                ?>

                          
                            
                            </a></div>
                            </div> 
                        </div>
                        <hr>
                      
                    </div>
            <div class="tab-pane fade" id="proposalTab" role="tabpanel">
    <div class="card card-body">

        <?php if($lead['status'] == 'pending'){ ?>

        <h5 class="fw-bold mb-3">Assign Project Manager</h5>

        <form method="post" action="assign_pm.php" id="assignPmForm">

            <input type="hidden" name="project_id" value="<?php echo $lead['id']; ?>">

            <div class="row mb-4">
                <div class="col-lg-3 fw-medium">Select Project Manager</div>
                <div class="col-lg-6">
                    <select name="pm_id" class="form-select" required>
                        <option value="">-- Select PM --</option>
                        <?php
                        $pmQ = mysqli_query($conn,"SELECT id,name FROM userspm WHERE status='active'");
                        while($pm = mysqli_fetch_assoc($pmQ)){
                        ?>
                        <option value="<?php echo $pm['id']; ?>">
                            <?php echo $pm['name']; ?>
                        </option>
                        <?php } ?>
                    </select>
                </div>
            </div>

            <div class="row mb-4">
                <div class="col-lg-3 fw-medium">Project Phases</div>
                <div class="col-lg-9">
                    <ul class="list-group">
                        <li class="list-group-item">Phase 1 – Biomass Availability</li>
                        <li class="list-group-item">Phase 2 – Technical Viability</li>
                        <li class="list-group-item">Phase 3 – Financial Viability</li>
                        <li class="list-group-item">Phase 4 – Risk Assessment & Closure</li>
                    </ul>
                </div>
            </div>

            <div class="text-end">
                <button type="submit" name="assign_pm" class="btn btn-primary">
                    Assign Project Manager
                </button>
            </div>

        </form>

        <?php } else { ?>

        <!-- Already Assigned -->
        <div class="text-center py-5">
            <h5 class="fw-semibold">Project Already Assigned</h5>
            <p class="text-muted mb-3">This project is already in progress.</p>

            <?php
            $pmInfo = mysqli_fetch_assoc(
                mysqli_query($conn,"SELECT name FROM userspm WHERE id='{$lead['pm_id']}'")
            );
            ?>

            <span class="badge bg-soft-success text-success fs-12">
                Assigned PM: <?php echo $pmInfo['name']; ?>
            </span>
        </div>

        <?php } ?>
        <br/>
    <?php
$phasesQ = mysqli_query($conn,"
    SELECT phase_no, phase_name, status 
    FROM project_phases 
    WHERE project_id={$lead['id']}
    ORDER BY phase_no
");

$completed = 0;
$total = 4;
$phases = [];

while($p = mysqli_fetch_assoc($phasesQ)){
    $phases[] = $p;
    if($p['status'] == 'approved'){
        $completed++;
    }
}

$progressPercent = ($completed / $total) * 100;
?>
      <h6 class="fw-semibold mb-2" align="center">Project Progress</h6>

        <div class="progress" style="height: 12px;">
            <div class="progress-bar progress-bar-striped progress-bar-animated bg-success"
                 role="progressbar"
                 style="width: <?php echo $progressPercent; ?>%">
            </div>
        </div>

        <small class="text-muted mt-2 d-block">
            <?php echo round($progressPercent); ?>% Completed
        </small>

    </div>
</div>

                    <div class="tab-pane fade" id="tasksTab" role="tabpanel">
                        <div class="card card-body">
                           
                                   <h5 class="fw-bold mb-4">Project Phases</h5>

        <?php while($p = mysqli_fetch_assoc($phasesQd)){ ?>

        <div class="border rounded p-3 mb-3 d-flex justify-content-between align-items-center">

            <!-- LEFT -->
            <div>
                <h6 class="mb-1">
                    Phase <?= $p['phase_no']; ?> :
                    <?= htmlspecialchars($p['phase_name']); ?>
                </h6>

                <?php
                if($p['status']=='approved'){
                    echo '<span class="badge bg-soft-success text-success">Approved</span>';
                }
                elseif($p['status']=='submitted'){
                    echo '<span class="badge bg-soft-warning text-warning">Submitted</span>';
                }
                elseif($p['status']=='correction'){
                    echo '<span class="badge bg-soft-danger text-danger">Correction Required</span>';
                }
                elseif($p['status']=='in_progress'){
                    echo '<span class="badge bg-soft-primary text-primary">In Progress</span>';
                }
                else{
                    echo '<span class="badge bg-soft-secondary text-muted">Pending</span>';
                }
                ?>
            </div>

            <!-- RIGHT -->
            <div class="text-end">
    <?php if(in_array($p['status'],['in_progress','correction'])){ ?>
                    <a href="phase_work.php?phase_id=<?= $p['id']; ?>&project_id=<?= $lead['id']; ?>"
                       class="btn btn-sm btn-primary">
                        Work on Phase
                    </a>
                <?php } ?>
                <?php if($p['status']=='submitted'){ ?>
                    <span class="text-muted fs-12 d-block mb-2">
                        Waiting for Admin
                    </span>

                    <a href="phase_review.php?phase_id=<?= $p['id']; ?>&project_id=<?= $project_id ?>"
                       class="btn btn-sm btn-primary">
                        Review Phase
                    </a>
                <?php } ?>

                <?php if($p['status']=='approved'){ ?>
                    <span class="text-success fs-12">
                        ✔ Approved
                    </span>
                <?php } ?>

                <?php if($p['status']=='correction'){ ?>
                    <a href="phase_review.php?phase_id=<?= $p['id']; ?>&project_id=<?= $project_id ?>"
                       class="btn btn-sm btn-danger">
                        View Correction
                    </a>
                <?php } ?>

            </div>

        </div>

        <?php } ?>


 
                          
                        </div>
                    </div>
                    <div class="tab-pane fade" id="notesTab" role="tabpanel">
                        <div class="card card-body">
                            <div class="d-flex align-items-center justify-content-center" style="height: calc(100vh - 315px)">
                                <div class="text-center">
                                    
                                
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="commentTab" role="tabpanel">
                        <div class="card card-body">
                            <div class="d-flex align-items-center justify-content-center" style="height: calc(100vh - 315px)">
                                <div class="text-center">
                                    <h2 class="fs-16 fw-semibold">No comments yet!</h2>
                                    <p class="fs-12 text-muted">There is no comments posted yet.</p>
                                    <a href="javascript:void(0);" class="avatar-text bg-soft-primary text-primary mx-auto" data-bs-toggle="tooltip" title="Add Comments">
                                        <i class="feather-plus"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ Main Content ] end -->
        </div>
        <!-- [ Footer ] start -->
        <?php include("footer.php"); ?>
        <!-- [ Footer ] end -->
    </main>
    <!--! BEGIN: Vendors JS !-->
    <script src="assets/vendors/js/vendors.min.js"></script>
    <!-- vendors.min.js {always must need to be top} -->
    <script src="assets/vendors/js/select2.min.js"></script>
    <script src="assets/vendors/js/select2-active.min.js"></script>
    <script src="assets/vendors/js/datepicker.min.html"></script>
    <script src="assets/vendors/js/lslstrength.min.html"></script>
    <!--! END: Vendors JS !-->
    <!--! BEGIN: Apps Init  !-->
    <script src="assets/js/common-init.min.js"></script>
    <script src="assets/js/customers-create-init.min.js"></script>
    <!--! END: Apps Init !-->
    <!--! BEGIN: Theme Customizer  !-->
    <script src="assets/js/theme-customizer-init.min.js"></script>
    <!--! END: Theme Customizer !-->
<script>
function printPage() {
    window.print();
}
</script>
<?php
session_start();
?>

<?php if (isset($_SESSION['assign_success'])) { ?>
<script>
Swal.fire({
    icon: 'success',
    title: 'Assigned Successfully',
    text: '<?php echo $_SESSION['assign_success']; ?>',
    timer: 2500,
    showConfirmButton: false
});
</script>
<?php unset($_SESSION['assign_success']); } ?>


<?php if (isset($_SESSION['assign_error'])) { ?>
<script>
Swal.fire({
    icon: 'error',
    title: 'Assignment Failed',
    text: '<?php echo $_SESSION['assign_error']; ?>'
});
</script>
<?php unset($_SESSION['assign_error']); } ?>
</body>
</html>
